<?php

class DatiList extends Base_Db_Table
{
	protected $_name = "dati";		// Nome della tabella nel DB
	protected $_primary = "id";		// Chiave primaria
	protected $_sequence = true;	// La chiave e` auto incrementante
	protected $_rowClass ="Dati";	// Nome della classe che contiene una riga del DB
	
	/**
	 * Questa e` una funzione di appoggio richiamata da Base_Db_Table
	 * (definita in /app/classes/Base/Db/Table.php)
	 * che e` una classe personale che estende Zend_Db_Table
	 * 
	 * Serve a creare la tabella nel DB nel caso non esista.
	 * 
	 * Deve avere esattamente questo nome.
	 */
	protected function create_table()
	{
		$db = $this->getAdapter();
		
		$st = $db->query("
			create table " .$this->_name. " (
			  id           int primary key auto_increment,
			  created_on   int,
			  updated_on   int,
			  s1           varchar(255),
			  s2           text,
			  s3           int,
			  s4           date,
			);
		");
	}
	
	
}
