<?php

require_once 'Zend/Loader.php';

class Bootstrap
{
	public static $frontController = null;
	public static $registry = null;
	public static $root = null;
	public static $appdir = null;
	public static $webdir = null;
	public static $auth = null;
	
	/**
	 * Questa funzione viene richiamata dall'index
	 * Prepara l'ambiente, calcola ed esegue controller e action,
	 * e manda il risultato al browser
	 */
	public static function run()
	{
		self::prepare();
		$response = self::$frontController->dispatch();
		self::sendResponse($response);
	}
	
	/**
	 * Preparazione dell'ambiente.
	 * oltre alle altre operazioni, imposta anche il locale
	 */
	public static function prepare()
	{
		self::setupPaths();
		self::setupEnvironment();
		Zend_Loader::registerAutoload();
		Zend_Locale::setDefault('it');
		setlocale(LC_ALL, "it_IT.UTF-8", "it_IT@euro", "it_IT", "ita_ita");
		self::setupRegistry();
		self::setupConfiguration();
		self::setupDatabase();
		self::setupFrontController();
		self::setupView();
	}
	
	/**
	 * Calcola le directory "base" dell'applicazione, la root, la app e la web
	 * che verranno usate nel resto dell'applicazione
	 */
	public static function setupPaths()
	{
		// Per calcolare la root risaliamo di tre livelli,
		// siamo in /app/classes/Bootstrap.php
		self::$root = dirname(dirname(dirname(__FILE__)));
		self::$appdir = self::$root. "/app";
		self::$webdir = self::$root ."/web";
	}
	
	/**
	 * Imposta l'ambiente in generale, attivando il report di tutti i
	 * tipi di errore (puo` essere modificato in produzione), imopstando
	 * il timezone e definendo l'encoding di default delle funzioni mb
	 */
	public static function setupEnvironment()
	{
		error_reporting(E_ALL|E_STRICT);
		ini_set('display_errors', true);
		date_default_timezone_set('Europe/Rome');
		mb_internal_encoding("UTF-8");
	}
	
	
	/**
	 * Impostazione del front controller: lancia eccezioni, ritorna
	 * la pagina come oggetto Zend_Response_Http invece di mandarla direttamente
	 * al browser, e imposta le directory dove si trovano i controller.
	 */
	public static function setupFrontController()
	{
		self::$frontController = Zend_Controller_Front::getInstance();
		self::$frontController->throwExceptions(true);
		self::$frontController->returnResponse(true);
		self::$frontController->setControllerDirectory(
			array(
				"default" => self::$appdir . '/controllers'
				
				// E` possibile impostare directory aggiuntive per i moduli
				
				//,"admin" => self::$appdir . "/modules/admin/controllers"
				
			)
		);
		/* Si puo` impostare anche una directory per i moduli che implementano
		 * la struttura standard nomemodulo/controllers e nomemodulo/views
		 */
		self::$frontController->addModuleDirectory(self::$appdir."/modules");
		
		self::$frontController->setParam('registry', self::$registry);
	}
	
	/**
	 * Prepara la parte View dell'MVC, impostando l'encoding e i path a cui trovare
	 * i template (scripts) e gli helpers.
	 * Inoltre definisce e attiva il plugin ViewRenderer, che permette di
	 * bufferizzare e di inviare automaticamente all'oggetto Response la pagina.
	 */
	public static function setupView()
	{
		$view = new Zend_View;
		$view->setEncoding('UTF-8');
		$view->viewSuffix = "php";
		$view->setScriptPath(self::$root . "/views/scripts");
		$view->setHelperPath(self::$root . "/views/helpers", "VH");
		$viewRenderer = new Zend_Controller_Action_Helper_ViewRenderer($view);
		$viewRenderer->setViewSuffix($view->viewSuffix);
		Zend_Controller_Action_HelperBroker::addHelper($viewRenderer);
	}
	
	/**
	 * Imposta un registry, in cui memorizzare dati da passare tra i vari
	 * componenti del framework durante l'elaborazione della pagina
	 */
	public static function setupRegistry()
	{
		self::$registry = new Zend_Registry(array(), ArrayObject::ARRAY_AS_PROPS);
		Zend_Registry::setInstance(self::$registry);
	}
	
	/**
	 * Carica la configurazione da /app/config/config.ini, nella sezione [general]
	 * e la salva nel registry appena definito
	 */
	public static function setupConfiguration()
	{
		$config = new Zend_Config_Ini(
			self::$appdir . '/config/config.ini',
			'general'
		);
		self::$registry->configuration = $config;
	}

	/**
	 * Imposta la connessione al database prendendo le informazioni, lette dal
	 * config.ini, dal registry
	 */
	public static function setupDatabase()
	{
		$config = self::$registry->configuration;
		$db = Zend_Db::factory($config->db->adapter, $config->db->toArray());
		
		// Questo non e` SQL standard, ma e` necessario per usare UTF-8 con MySQL
		// purtroppo questo rende l'applicazione meno "cross-DB", e sarebbe
		// necessario impostare un check sul DB
		$db->query("SET NAMES 'utf8'");
		
		// La definizione del DB viene salvata nel registry e impostata per tutte
		// le tabelle che useremo, come default
		self::$registry->database = $db;
		Zend_Db_Table::setDefaultAdapter($db);
	}
	
	
	/**
	 * Imposta l'header HTTP per il tipo di contenuto e l'encoding e
	 * invia finalmente la pagina al browser
	 */
	public static function sendResponse(Zend_Controller_Response_Http $response)
	{
		$response->setHeader('Content-Type', 'text/html; charset=UTF-8', true);
		$response->sendResponse();
	}

}
