<?php

/**
 * Questa classe estende la classe base del framework inserendo un controllo
 * a livello di inizializzazione (_setupMetadata) che verifica se la tabella
 * esiste nel DB, ed eventualmente la crea richiamando la funzione definita
 * nei model (vedi esempi di Model)
 */
class Base_Db_Table extends Zend_Db_Table_Abstract
{
	
	protected function _setupMetadata()
	{
			// Prima controlla se la tabella esiste in DB
		if ( ! $this->check_table()) {
			
				// Se non lo e`, e se e` definita la funzione di creazione, la crea
			if (method_exists($this, "create_table")) {
				$this->create_table();
			}
		}
			
			// Quindi imposta i metadati prendendoli dal DB
		parent::_setupMetadata();
			// Se non e` ruscito a creare la tabella sollevera` un'eccezione
	}

	protected function check_table()
	{
		static $tables = null;
		if ($tables == null) {
			$tables = $this->getAdapter()->listTables();
		}
		
		if (!in_array($this->_name, $tables)) {
			return false;
		}
		
		return true;
	}
		
	
	/**
	 * Le seguenti due funzioni dimostrano come si possa estendere i comportamenti
	 * automatici dei model. In particolare ogni volta che si salva un dato in DB
	 * viene richiamata una delle seguenti funzioni, a seconda che si tratti di un
	 * insert o di un update.
	 * Noi lo utilizziamo per aggiornare due campi della tabella (che dobbiamo
	 * ricordarci di creare di tipo int: il framework NON li crea da solo) con
	 * i timestamp dell'operazione di creazione e di aggiornamento dei dati.
	 * 
	 * Bisogna SEMPRE ricordarsi di richiamare la medesima funzione del genitore (parent)
	 * quando si estende una funzione gia` esistente.
	 */
	public function insert(array $data)
	{
		$data["created_on"] = time();
		$data["updated_on"] = $data["created_on"];
		return parent::insert($data);
	}

	public function update(array $data, $where)
	{
		$data["updated_on"] = time();
		return parent::update($data, $where);
	}
	
}

