<?php

/**
 * Qui vediamo come possiamo estendere il comportamento del Controller di base del
 * framework.
 * 
 * In particolare vediamo come intercettare automaticamente delle variabili passate
 * nell'URL (nell'esempio, per l'impostazione della lingua), come impostare delle
 * variabili nella view in modo trasparente (l'URL di base e il modulo, controller e
 * azione richiamati) e come creare un FlashMessenger usabile da tutti i controller
 * (vedi documentazione di ZF)
 */
class Base_Controller_Action extends Zend_Controller_Action
{
	public function init()
	{
		// Recupera i parametri passati alla pagina
		$params = $this->getRequest()->getParams();
		
		// Se e` definito il parametro "lang", controlla se e` it o en e, in caso,
		// salvane il valore in sessione, altrimenti salva "it"
		if (isset($params["lang"])) {
			if ($params["lang"] == "it" || $params["lang"] == "en") {
				$_SESSION["lang"] = $params["lang"];
			}
		}
		if ( ! isset($_SESSION["lang"])) {
			$_SESSION["lang"] = "it";
		}
		
		// Preimposta nella view tre variabili per modulo, controller e view richiamate
		// e una che memorizza l'URL di base, da usare, per esempio, nei path per
		// le immagini o i css (vedi esempio sotto /app/views/script/index/index.php)
		$this->view->sitemodule = $params["module"];
		$this->view->sitecontroller = $params["controller"];
		$this->view->siteaction = $params["action"];
		$this->view->baseUrl = $this->getRequest()->getBaseUrl();

		// Imposta il FlashMessenger in modo che lo vedano sia il controller che la view
		$this->messenger = $this->_helper->getHelper('FlashMessenger');
		$this->view->messenger = $this->messenger;
	}
	
	/**
	 * Questa e` una funzione di comodo che permette di fare i redirect in modo
	 * semplice e pulito tramite un "plugin" del Controller.
	 */
	public function redirect($controller="index", $action="index", $param=array(), $module="")
	{
		$redirector = Zend_Controller_Action_HelperBroker::getStaticHelper("redirector");
    	$redirector->goto($action, $controller, $module, $param);
		
	}
	
	/**
	 * Altra funzione di comodo che puo` essere usata in ogni controller per inviare una
	 * mail all'amministratore del server, per esempio per debug
	 */
	public function emailAdmin($message)
	{
		$msg = "Errore:\n" . $message. "\n\n";
		$msg .= "Modulo     : " .$this->view->sitemodule."\n";
		$msg .= "Controller : " .$this->view->sitecontroller."\n";
		$msg .= "Azione     : " .$this->view->siteaction."\n";
		
		$mail = new Zend_Mail();
		$mail->setBodyText($msg)
			->setFrom("sito@example.com")
			->addTo("sysadmin@example.com")
			->setSubject("Errore sito");
		
		$mail->send();
		
	}
	
}
